% Copyright (c) 2013, Massachusetts Institute of Technology
% This program was presented in the book "Visual Psychophysics:
% From Laboratory to Theory" by Zhong-Lin Lu and Barbara Dosher.
% The book is available at http://mitpress.mit.edu/books/visual-psychophysics

%%% Program CSFcomp_costfunc.m
function L = CSFcomp_costfunc(guess, data)

NCSF = size(data, 1)/2; % compute # of CSFs for comparison
Nfrequencies = size(data, 2); % # of stimulus conditions
Gmax = guess(1);
Fmax = guess(2);
beta = guess(3);
delta = guess(4);

L=0;
for n = 1 : NCSF
    f = data((n-1)*2+1, :);
    S_observed = log10(data(2*n, :));
    S_predicted = [];
    for i=1:Nfrequencies    
        S = log10(Gmax) - log10(2) * ((log10(f(i)) - ...
            log10(Fmax))/(log10(2*beta)/2))^2;
        if (f(i) >= Fmax)
            S = S;
        elseif (f(i) < Fmax & S < log10(Gmax) - delta)
            S = log10(Gmax) - delta;
        end
        S_predicted = [ S_predicted S ];
    end
    L = L+sum( (S_observed - S_predicted).^2 );
end
